define(['angular', 'app'], function (angular, app) {
  'use strict';

  app.directive('requiredNonZeroValue', function() {
    return {
      restrict: 'A',
      require: 'ngModel',
      link: function(scope, elem, attr, ngModel) {
        ngModel.$parsers.push(function(value){
          var modelValue = value;
          if (value === null || value === 0 ) {
            modelValue = 0;
            ngModel.$setValidity('is_valid', false);
          }
          return modelValue;
        });

        ngModel.$formatters.push(function(value){
          var viewValue = (value === 0) ? null : value;

          return viewValue;
        });
      }
    };
  });
});